/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.google.common.collect.Lists;
import com.minecolonies.api.colony.buildings.IBuilding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;

public class WorldUtil {
    public static boolean isBlockLoaded(IWorld world, BlockPos pos) {
        return WorldUtil.isChunkLoaded(world, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public static boolean isChunkLoaded(IWorld world, int x, int z) {
        return world.func_217353_a(x, z, ChunkStatus.field_222617_m, false) != null;
    }

    public static void markChunkDirty(World world, BlockPos pos) {
        if (WorldUtil.isBlockLoaded((IWorld)world, pos)) {
            world.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4).func_76630_e();
            BlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public static boolean isChunkLoaded(IWorld world, ChunkPos pos) {
        return WorldUtil.isChunkLoaded(world, pos.field_77276_a, pos.field_77275_b);
    }

    public static boolean isEntityBlockLoaded(IWorld world, BlockPos pos) {
        return WorldUtil.isEntityChunkLoaded(world, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public static boolean isEntityChunkLoaded(IWorld world, int x, int z) {
        return WorldUtil.isEntityChunkLoaded(world, new ChunkPos(x, z));
    }

    public static boolean isEntityChunkLoaded(IWorld world, ChunkPos pos) {
        return world.func_72863_F().func_222865_a(pos);
    }

    public static boolean isAABBLoaded(World world, AxisAlignedBB box) {
        return WorldUtil.isChunkLoaded((IWorld)world, (int)box.field_72340_a >> 4, (int)box.field_72339_c >> 4) && WorldUtil.isChunkLoaded((IWorld)world, (int)box.field_72336_d >> 4, (int)box.field_72334_f >> 4);
    }

    public static boolean isDayTime(World world) {
        return world.func_72820_D() % 24000L <= 12600L;
    }

    public static boolean isPastTime(World world, int pastTime) {
        return world.func_72820_D() % 24000L <= (long)pastTime;
    }

    public static boolean isPastNoon(World world) {
        return WorldUtil.isPastTime(world, 6000);
    }

    public static boolean isOverworldType(@NotNull World world) {
        return WorldUtil.isOfWorldType(world, (RegistryKey<DimensionType>)DimensionType.field_235999_c_);
    }

    public static boolean isNetherType(@NotNull World world) {
        return WorldUtil.isOfWorldType(world, (RegistryKey<DimensionType>)DimensionType.field_236000_d_);
    }

    public static boolean isOfWorldType(@NotNull World world, @NotNull RegistryKey<DimensionType> type) {
        DynamicRegistries dynRegistries = world.func_241828_r();
        ResourceLocation loc = dynRegistries.func_230520_a_().func_177774_c((Object)world.func_230315_m_());
        if (loc == null) {
            if (world.field_72995_K) {
                return world.func_230315_m_().func_242725_p().equals((Object)type.func_240901_a_());
            }
            return false;
        }
        RegistryKey regKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)loc);
        return regKey == type;
    }

    public static boolean isPeaceful(@NotNull World world) {
        return !world.func_72912_H().func_82574_x().func_223586_b(GameRules.field_223601_d) || world.func_175659_aa().equals((Object)Difficulty.PEACEFUL);
    }

    public static boolean setBlockState(IWorld world, BlockPos pos, BlockState state) {
        if (world.func_201670_d()) {
            return world.func_180501_a(pos, state, 3);
        }
        return WorldUtil.setBlockState(world, pos, state, 3);
    }

    public static boolean setBlockState(IWorld world, BlockPos pos, BlockState state, int flags) {
        if (world.func_201670_d() || !(world instanceof ServerWorld)) {
            return world.func_180501_a(pos, state, flags);
        }
        if ((flags & 2) != 0) {
            Set navigators = ((ServerWorld)world).field_217495_I;
            ((ServerWorld)world).field_217495_I = Collections.emptySet();
            boolean result = world.func_180501_a(pos, state, flags);
            ((ServerWorld)world).field_217495_I = navigators;
            return result;
        }
        return world.func_180501_a(pos, state, flags);
    }

    public static boolean removeBlock(IWorld world, BlockPos pos, boolean isMoving) {
        FluidState fluidstate = world.func_204610_c(pos);
        return WorldUtil.setBlockState(world, pos, fluidstate.func_206883_i(), 3 | (isMoving ? 64 : 0));
    }

    public static <T extends Entity> List<T> getEntitiesWithinBuilding(@NotNull World world, @NotNull Class<? extends T> clazz, @NotNull IBuilding building, @Nullable Predicate<? super T> predicate) {
        Tuple<BlockPos, BlockPos> corners = building.getCorners();
        int minX = ((BlockPos)corners.func_76341_a()).func_177958_n() >> 4;
        int maxX = ((BlockPos)corners.func_76340_b()).func_177958_n() >> 4;
        int minZ = ((BlockPos)corners.func_76341_a()).func_177952_p() >> 4;
        int maxZ = ((BlockPos)corners.func_76340_b()).func_177952_p() >> 4;
        int minY = Math.max(0, ((BlockPos)corners.func_76341_a()).func_177956_o()) >> 4;
        int maxY = Math.min(((BlockPos)corners.func_76340_b()).func_177956_o(), world.func_234938_ad_()) >> 4;
        ArrayList list = Lists.newArrayList();
        AbstractChunkProvider abstractchunkprovider = world.func_72863_F();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                Chunk chunk;
                if (!WorldUtil.isEntityChunkLoaded((IWorld)world, x, z) || (chunk = abstractchunkprovider.func_225313_a(x, z)) == null) continue;
                for (int y = minY; y <= maxY; ++y) {
                    for (Entity entity : chunk.func_177429_s()[y].func_219790_a(clazz)) {
                        if (!building.isInBuilding(entity.func_233580_cy_()) || predicate != null && !predicate.test(entity)) continue;
                        list.add(entity);
                    }
                }
            }
        }
        return list;
    }
}

